//Conventions:
//    Global constants (declared with const) and #defines - all uppercase letters with words separated 
//        by underscores.
//        (E.G., #define MY_DEFINE 5).
//        (E.G., const int MY_CONSTANT = 5;).
//    New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//        lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//        associating them with a particular enumerated set.
//        (E.G., typedef int MyTypedef;).
//        (E.G., enum MyEnumConst {MEC_ONE, MEC_TWO};)
//    Global variables - begin with "g_" followed by lowercase words separated by underscores.
//        (E.G., int g_my_global;).
//    Local variables - begin with a lowercase letter followed by lowercase words separated by
//        underscores.
//        (E.G., int my_local;).
//    Argument variables - begin with "a_" followed by lowercase words separated by underscores.
//        (E.G., ...int a_my_argument, ...).
//    Member variables - begin with "m_" followed by lowercase words separated by underscores.
//        (E.G., int m_my_member;).
//    Functions (member or global) - begin with an uppercase letter followed by lowercase words
//        separated by uppercase letters.
//        (E.G., void MyFunction(void);).
#pragma once


#include "EventAddOnPublic.h"	//Note: EventAddOnPublic requires the Santa's gift bag distribution 
#include "WrappingTextView.h"


class MessageSoundDataHandler : public EventAddOnData
{
	public:
		MessageSoundDataHandler(Event* a_attach_to,BufferedFile* a_file,bool* a_file_ok);

		//Overrides
		~MessageSoundDataHandler();
		BView* CreateEditView(BRect a_frame);
		bool SaveData(BufferedFile* a_file);
		void DealWithEvent(bool a_treat_as_late);
		void SetMessage(const char* a_new_message);
		const char* GetMessage();

	private:
		char* m_message;
};


int32 PlayMessageSound(void* data);


class MessageSoundEditView : public BView
{
	public:
		MessageSoundEditView(BRect frame,MessageSoundDataHandler* a_attach_to);
		virtual ~MessageSoundEditView();
		virtual void AttachedToWindow();
		virtual void MessageReceived(BMessage* a_message);

	private:
		BButton* m_button;
		BFilePanel *m_file_panel;
};


const int32 MSG_SET_SOUND = 'ssnd';


class MessageSoundEditTextView : public WrappingTextView
{
	public:
		MessageSoundEditTextView(BRect a_frame,MessageSoundDataHandler* a_attach_to);
		virtual ~MessageSoundEditTextView();
		virtual void StoreChange();

	private:
		MessageSoundDataHandler* m_attached_to;
};


extern "C" __declspec(dllexport) char* InitializeAddOn();
extern "C" __declspec(dllexport) EventAddOnData* NewAddOnData(Event* AttachTo,BufferedFile* LoadFile,bool* FileOK);
extern "C" __declspec(dllexport) void CleanUpAddOn();
